﻿using Microscopic_Traffic_Simulator.ViewModels;

namespace Microscopic_Traffic_Simulator
{
    /// <summary>
    /// Class implementing ISetting interface using settings of visual studio application.
    /// </summary>
    class Settings : ISettings
    {
        /// <summary>
        /// Path of last opened geometric topology file.
        /// </summary>
        public string LastGeometricTopologyPath
        {
            get { return Properties.Settings.Default.LastGeometricTopologyPath; }
            set { Properties.Settings.Default.LastGeometricTopologyPath = value; }
        }

        /// <summary>
        /// Seed used in the previous simulation run.
        /// </summary>
        public int PreviousSeed
        {
            get { return Properties.Settings.Default.PreviousSeed; }
            set { Properties.Settings.Default.PreviousSeed = value; }
        }

        /// <summary>
        /// Determines whether any simulation was performed (whether any previous seed is available).
        /// </summary>
        public bool PreviousSeedNull
        {
            get { return Properties.Settings.Default.PreviousSeedNull; }
            set { Properties.Settings.Default.PreviousSeedNull = value; }
        }

        /// <summary>
        /// Determines whether the seed is initialized automatically.
        /// </summary>
        public bool IsSeedSettingAutomatic 
        {
            get { return Properties.Settings.Default.IsSeedSettingAutomatic; }
            set { Properties.Settings.Default.IsSeedSettingAutomatic = value; }
        }

        /// <summary>
        /// Determines whether the seed from previous simulation run is used.
        /// </summary>
        public bool IsPreviousSeedUsed 
        {
            get { return Properties.Settings.Default.IsPreviousSeedUsed; }
            set { Properties.Settings.Default.IsPreviousSeedUsed = value; }
        }

        /// <summary>
        /// Path to last used file with parameters.
        /// </summary>
        public string PathToParameters
        {
            get { return Properties.Settings.Default.PathToParameters; }
            set { Properties.Settings.Default.PathToParameters = value; }
        }
        
        /// <summary>
        /// Save settings.
        /// </summary>
        public void Save()
        {
            Properties.Settings.Default.Save();
        }
    }
}
